@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Payments</h5>
                            </div>
                            <a href="{{ route('product-payment-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp;
                                Add Payments</a>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                            S.NO</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                            Product Details Code</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                            Product</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                            Payment Status</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7 ps-2">
                                            Purchased Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs text-center font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($payments_data as $index => $data)
                                        <tr>
                                            <td class="text-center">{{ $index + 1 }}</td>
                                            <td class="ps-4">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $data->product_details_code ?? ''}}
                                                </p>
                                            </td>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $data->name ?? '' }}</p>
                                            </td>
                                            <td class="ps-4 text-center">
                                                @php
                                                    $status = optional($data->paymentStatus)->name ?? 'Unpaid';
                                                    $badgeClass = [
                                                        'Paid' => 'bg-success',
                                                        'Partially Paid' => 'bg-warning text-dark',
                                                        'Unpaid' => 'bg-danger'
                                                    ][$status] ?? 'bg-secondary';
                                                @endphp
                                                <span class="badge {{ $badgeClass }} text-xs text-center font-weight-bold">
                                                    {{ $status }}
                                                </span>
                                            </td>

                                            <td class="ps-4">
                                                <p class="text-xs text-center font-weight-bold mb-0">
                                                    {{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y') ?? '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <a href="{{ route('product-payment-edit', $data->product_details_sid) }}">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <span class="ms-2">
                                                    <form
                                                        action="{{ route('product-payment-delete', $data->product_details_sid) }}"
                                                        method="POST" class="d-inline"
                                                        id="delete-form-{{$data->product_details_sid}}">
                                                        @csrf
                                                        @method('DELETE')
                                                        <i class="cursor-pointer fas fa-trash text-secondary"
                                                            onclick="confirmDelete({{ $data->product_details_sid }})"></i>
                                                    </form>
                                                </span>

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function () {
            $('[data-bs-toggle="tooltip"]').tooltip();
        });
    </script>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush