@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Clients</h5>
                            </div>
                            <div>
                                <a href="{{ route('client-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                    Client</a>
                                    <a href="{{route('client-import-index')}}" class="btn bg-gradient-primary btn-sm mb-0"> Bulk
                                        Import</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">
                        {{-- <div class="d-flex justify-content-between align-items-center mb-3 px-3">
                            <form action="{{ route('client-index') }}" method="GET">
                                <input type="text" name="search" class="form-control" placeholder="Search..."
                                    style="width: 300px;" value="{{ request('search') }}">
                            </form>
                        </div> --}}
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">ID
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Client Name</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Client Number</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Client Email</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Company Name</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Status</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($clients as $client)
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $loop->iteration }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $client->user->name ?? ''}}
                                                    {{ $client->user->last_name ?? '' }}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $client->user->phone ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $client->user->email ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $client->company_name ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $client->active_status == "A" ? "Active" : "Inactive" }}
                                                </p>
                                            </td>
                                            <td>
                                                <a href="{{ route('client-edit', ['id'=>$client->id]) }}" >
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <span class="ms-2">
                                                <form action="{{ route('client-delete', $client->id) }}" method="POST"
                                                    class="d-inline" id="delete-form-{{$client->id}}">
                                                    @csrf
                                                    @method('DELETE')                                                   
                                                        <i class="cursor-pointer fas fa-trash text-secondary" onclick="confirmDelete({{ $client->id }})"></i>                                                
                                                </form>
                                            </span>
                                            </td>
                                        </tr>                                   
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            function confirmDelete(clientId) {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + clientId).submit();
                    }
                });
            }
        </script>

    @endpush
@endsection