@extends('layouts.layoutapp')
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Create New Admin</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admins-store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-lg-6 row">
                                <div class="col-lg-6 mb-3">
                                    <label for="first_name" class="form-label">First Name:</label>
                                    <input type="text" id="first_name" name="first_name" class="form-control"
                                        value="{{ old('first_name') }}" required>
                                    @error('first_name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="last_name" class="form-label">Last Name:</label>
                                    <input type="text" id="last_name" name="last_name" class="form-control"
                                        value="{{ old('last_name') }}" required>
                                    @error('last_name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="email" class="form-label">Email:</label>
                                    <input type="email" id="email" name="email" class="form-control"
                                        value="{{ old('email') }}" required>
                                    @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="contact_no" class="form-label">Contact No:</label>
                                    <input type="text" id="contact_no" name="contact_no" class="form-control"
                                        value="{{ old('contact_no') }}" required>
                                    @error('contact_no') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="password" class="form-label">Password:</label>
                                    <input type="password" id="password" name="password" class="form-control" required>
                                    @error('password') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="password_confirmation" class="form-label">Confirm Password:</label>
                                    <input type="password" id="password_confirmation" name="password_confirmation"
                                        class="form-control" required>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="role" class="form-label">Role:</label>
                                    <select class="form-select" name="role" required>
                                        <option value="">Select role</option>
                                        <option value="A" {{ old('role') == 'A' ? 'selected' : '' }}>Admin</option>
                                        <option value="S" {{ old('role') == 'S' ? 'selected' : '' }}>Staff</option>
                                    </select>
                                    @error('role') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="company" class="form-label">Company:</label>
                                    <select class="form-control" disabled>
                                        <option>{{ $company_name }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 row">
                                <div class="col-12 mb-3">
                                    <label for="profile_image" class="form-label">Profile:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-upload me-5">
                                            <div class="avatar-preview">
                                                <img id="profilePreview" src="{{ asset('assets/img/logos/profile.png') }}"
                                                    alt="Default Profile Image" class="img-fluid rounded-circle"
                                                    style="height:125px; width: auot; max-width: 250px;">
                                            </div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type="file" id="profile_image" name="profile_image"
                                                class="form-control file-upload-input" accept="image/*"
                                                onchange="previewImage(this)">
                                        </div>
                                    </div>
                                    @error('profile_image') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>

                                <div class="col-lg-6 mb-3">
                                    <label for="branch" class="form-label">Branch:</label>
                                    <select class="form-control" disabled>
                                        <option>{{ $branch_name }}</option>
                                    </select>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="address" class="form-label">Address:</label>
                                    <input type="text" id="address" name="address" class="form-control"
                                        value="{{ old('address') }}" required>
                                    @error('address') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="active_status" class="form-label">Active Status:</label>
                                    <select class="form-select" name="active_status" required>
                                        <option value="">Select active status</option>
                                        <option value="A" {{ old('active_status') == 'A' ? 'selected' : '' }}>Active
                                        </option>
                                        <option value="I" {{ old('active_status') == 'I' ? 'selected' : '' }}>Inactive
                                        </option>
                                    </select>
                                    @error('active_status') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">Save Admin</button>
                            <a href="{{ route('admins-index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('profilePreview').src = e.target.result;
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection