

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <!-- Card Header -->
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">All Categories</h5>
                        </div>
                        <div>
                            <a href="<?php echo e(route('category-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">
                                +&nbsp; New Category
                            </a>
                            <a href="<?php echo e(route('categories-import-index')); ?>" class="btn bg-gradient-primary btn-sm mb-0">
                                Bulk
                                Import</a>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0 table-hover" id="myTable">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        ID</th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Category Name</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Creation Date</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($loop->iteration); ?></p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($category->name); ?></p>
                                        </td>
                                        <td class="text-center">
                                            <p class="text-xs font-weight-bold mb-0">
                                                <?php echo e($category->created_at ? $category->created_at->format('d-m-Y') : ''); ?>

                                            </p>
                                        </td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('category-edit', $category->id)); ?>">
                                                <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                            </a>
                                            <span class="ms-2">
                                                <form action="<?php echo e(route('category-delete', $category->id)); ?>" method="POST"
                                                    class="d-inline" id="delete-form-<?php echo e($category->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <i class="cursor-pointer fas fa-trash text-secondary"
                                                        onclick="confirmDelete(<?php echo e($category->id); ?>)"></i>
                                                </form>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete(categoryId) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + categoryId).submit();
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/categories/index.blade.php ENDPATH**/ ?>