<?php

namespace App\Models;

use Barryvdh\LaravelIdeHelper\Eloquent;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ClientModel extends Model
{
    use HasFactory;

    protected $table = 'clients';

    public $timestamps = true;

    protected $primaryKey = 'id';

    public $fillable = [
        'user_id',
        'profile_img',
        'website',
        'postal_code',
        'address',
        'note',
        'country_id',
        'state_id',
        'city_id',
        'is_password_set',
        'gstin',
        'company_name',
        'branch_id',
        'active_status',
        'loyalty_points',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function clientAddress()
    {
        return $this->hasMany(ClientAddressModel::class, 'client_id');
    }
}
