

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Quotes</h5>
                            </div>
                            <a href="<?php echo e(route('quotes-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; Add
                                Quotes</a>
                        </div>
                    </div>

                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Quotes Id</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Quote Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Due Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Amount</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Status</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $quotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0"><?php echo e($quote->quote_id ?? 'Quotes'); ?></p>
                                            </td>
                                             <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0"><?php echo e($quote->client->user->name ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0"><?php echo e($quote->quote_date ? \Carbon\Carbon::parse($quote->quote_date)->format('d-m-Y') : ''); ?></p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0"><?php echo e($quote->due_date ? \Carbon\Carbon::parse($quote->due_date)->format('d-m-Y') : ''); ?></p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0"><?php echo e($quote->final_amount); ?></p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">
                                                    <?php if($quote->status == 1): ?>
                                                        <span class="badge bg-info">Draft</span>
                                                        <?php elseif($quote->status == 2): ?>
                                                        <span class="badge bg-warning">Partially Completed</span>
                                                        <?php elseif($quote->status == 3): ?>
                                                        <span class="badge bg-success">Completed</span>
                                                    <?php endif; ?>
                                                </p>

                                            </td>
                                            <td class="text-center">
                                                <div class="d-flex justify-content-center align-items-center gap-3">
                                                    <!-- Edit Quote -->
                                                    <a href="<?php echo e(route('quotes-edit', ['id' => $quote->id, 'type' => 'edit'])); ?>"
                                                        <?php if($quote->oprntl_flag == 'C'): ?>
                                                            style="pointer-events: none; opacity: 0.5;"
                                                        title="Edit Quote (Disabled)" <?php endif; ?>>
                                                        <i class="fa-solid fa-pen-to-square text-secondary fa-lg ms-2"
                                                            title="Edit Quote"></i>
                                                    </a>

                                                    <!-- Convert Quote -->
                                                    <a
                                                        href="<?php echo e(route('quotes-edit', ['id' => $quote->id, 'type' => 'convert'])); ?>">
                                                        <i class="fa-solid fa-money-bill-transfer text-secondary fa-lg ms-2"
                                                            title="Convert Quote"></i>
                                                    </a>

                                                    <!-- Download Invoice -->
                                                    <a href="<?php echo e(route('quote-pdf', $quote->id)); ?>">
                                                        <i class="fa-solid fa-download text-secondary ms-2"
                                                            title="Download Invoice"></i>
                                                    </a>

                                                    <!-- Delete Quote -->
                                                    <span class="ms-2">
                                                        <form action="<?php echo e(route('quotes-delete', $quote->id)); ?>" method="POST"
                                                            class="d-inline" id="delete-form-<?php echo e($quote->id); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <i class="fas fa-trash text-secondary fa-lg"
                                                                <?php if($quote->oprntl_flag == 'C'): ?>
                                                                    style="pointer-events: none; opacity: 0.5;"
                                                                    title="Delete Quote (Disabled)" <?php else: ?> title="Delete Quote"
                                                                onclick="confirmDelete(<?php echo e($quote->id); ?>)" <?php endif; ?>>
                                                            </i>
                                                        </form>
                                                    </span>
                                                </div>
                                            </td>
                                        </tr>                                  
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/quotes/index.blade.php ENDPATH**/ ?>